﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Ordering
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 8-11. Przykładowe dane
            List<CalendarEvent> events = new List<CalendarEvent>
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            // Listing 8-12. Sortowanie elementów w zapytaniu LINQ
            var eventsByStartTime = from ev in events
                                    orderby ev.StartTime
                                    select ev;

            PrintEvents(eventsByStartTime);

            // Listing 8-13. Kilka kryteriów sortowania.
            var eventsByStartDateThenDuration = from ev in events
                                                orderby ev.StartTime.Date, ev.Duration
                                                select ev;

            PrintEvents(eventsByStartDateThenDuration);

        }



        static void PrintEvents(IEnumerable<CalendarEvent> events)
        {
            foreach (CalendarEvent item in events)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }
        }
    }
}
